;; Analiza danych i definicje:
(define-struct uczen (imie nazwisko wychowawca))
;; uczen jest struktur: (make-uczen i n w), gdzie i, n i w s symbolami.

;; Kontrakt: zmien-wychowawce : uczen symbol -> uczen

;; Cel: stworzenie struktury uczen z nowym nazwiskiem wychowawcy, jeli obecny wychowawca nazywa si Nowak

;; Przykady:
;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Nowak) 'Miller)
;; =
;; (make-uczen 'Jan 'Kowalski 'Miller)

;; (zmien-wychowawce (make-uczen 'Jan 'Kowalski 'Wojciechowski) 'Miller)
;; =
;; (make-uczen 'Jan 'Kowalski 'Wojciechowski)

;; Szablon:
;; (define (przetwarzaj-uczen dany-uczen dany-wychowawca) 
;; Definicja danych:
(define-struct kwadrat (lewy-gorny-kat dlugosc-boku))
(define-struct kolo (srodek promien))
;; figura jest albo:
;; 1. struktur kolo: (make-kolo a b)
;;    gdzie a jest struktur posn za b jest liczb, albo
;; 2. struktur kwadrat: (make-kwadrat a b)
;;    gdzie a jest struktur posn za b jest liczb.

;; Kontrakt, cel i nagwek:
;; obwod : figura -> liczba
;; oblicza obwd figury opisanej parametrem dana-figura

;; Przykady: patrz testy

;; Szablon:
;; (define (f dana-figura)
;;   (cond
;;     [(kwadrat? dana-figura) 
;;        (kwadrat-lewy-gorny-kat dana-figura)  (kwadrat-dlugosc-boku dana-figura) ]
;;     [(kolo? dana-figura)
;;        (kolo-srodek dana-figura)  (kolo-promien dana-figura) ]))

;; Definicja:
(define (obwod dana-figura)
  (cond
    [(kwadrat? dana-figura) (* (kwadrat-dlugosc-boku dana-figura) 4)]
    [(kolo? dana-figura) (* (* 2 (kolo-promien dana-figura)) pi)]))

;; Testy: (zgodne z przykadami)
;; (= (obwod (make-kwadrat ... 3)) 12)
;; (= (obwod (make-kolo ... 1)) (* 2 pi))
